import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Define colors for statuses
colors = {
    'clear': 'green',
    'not_clear': 'red',
    'empty': 'blue'
}

# Add the table
table = patches.Rectangle((0.05, 0.05), 0.9, 0.1, linewidth=1, edgecolor='black', facecolor='lightgray')
ax.add_patch(table)
ax.text(0.5, 0.03, 'Table', ha='center', va='center', fontsize=8, color='black')

# Add blocks
blocks = {
    'a': {'pos': (0.1, 0.15), 'color': colors['not_clear'], 'status': 'Supports D'},
    'b': {'pos': (0.4, 0.15), 'color': colors['not_clear'], 'status': 'Supports C'},
    'c': {'pos': (0.4, 0.25), 'color': colors['clear'], 'status': 'Clear'},
    'd': {'pos': (0.1, 0.25), 'color': colors['clear'], 'status': 'Clear'},
    'e': {'pos': (0.7, 0.15), 'color': colors['clear'], 'status': 'Clear'}
}

for block, attrs in blocks.items():
    rect = patches.Rectangle(attrs['pos'], 0.2, 0.1, linewidth=1, edgecolor='black', facecolor=attrs['color'])
    ax.add_patch(rect)
    ax.text(attrs['pos'][0] + 0.1, attrs['pos'][1] + 0.05, f'{block.upper()}\n{attrs["status"]}', ha='center', va='center', fontsize=8, color='white')

# Add the hand
hand = patches.Ellipse((0.5, 0.5), 0.1, 0.05, linewidth=1, edgecolor='black', facecolor=colors['empty'])
ax.add_patch(hand)
ax.text(0.5, 0.5, 'Hand\nEmpty', ha='center', va='center', fontsize=8, color='black')

# Add legend
legend_patches = [
    patches.Patch(color=colors['clear'], label='Clear'),
    patches.Patch(color=colors['not_clear'], label='Not Clear'),
    patches.Patch(color=colors['empty'], label='Hand Empty')
]
ax.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.1, 1), fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_2.png', bbox_inches='tight')
plt.show()